/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import de.z0rdak.yawp.api.MessageSender;
import de.z0rdak.yawp.api.commands.CommandConstants;
import de.z0rdak.yawp.api.events.region.RegionEvent;
import de.z0rdak.yawp.api.permission.Permissions;
import de.z0rdak.yawp.commands.DimensionCommands;
import de.z0rdak.yawp.commands.arguments.ArgumentUtil;
import de.z0rdak.yawp.commands.arguments.region.ContainingOwnedRegionArgumentType;
import de.z0rdak.yawp.commands.arguments.region.RegionArgumentType;
import de.z0rdak.yawp.constants.Constants;
import de.z0rdak.yawp.core.region.IMarkableRegion;
import de.z0rdak.yawp.core.region.IProtectedRegion;
import de.z0rdak.yawp.core.stick.MarkerStick;
import de.z0rdak.yawp.data.region.DimensionRegionCache;
import de.z0rdak.yawp.data.region.RegionDataManager;
import de.z0rdak.yawp.platform.Services;
import de.z0rdak.yawp.util.ChatLinkBuilder;
import de.z0rdak.yawp.util.LocalRegions;
import de.z0rdak.yawp.util.StickUtil;
import java.util.Collections;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2181;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5321;

public final class MarkerCommands {
    private MarkerCommands() {
    }

    static LiteralArgumentBuilder<class_2168> build() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ArgumentUtil.literal(CommandConstants.MARKER).then(ArgumentUtil.literal(CommandConstants.GIVE).executes(MarkerCommands::giveMarkerStick))).then(ArgumentUtil.literal(CommandConstants.RESET).executes(MarkerCommands::resetStick))).then(ArgumentUtil.literal(CommandConstants.SELECT).then(class_2170.method_9244((String)CommandConstants.DIM.toString(), (ArgumentType)class_2181.method_9288()).then(class_2170.method_9244((String)CommandConstants.LOCAL.toString(), (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> RegionArgumentType.region().listSuggestions(ctx, builder)).executes(ctx -> MarkerCommands.selectRegion((CommandContext<class_2168>)ctx, ArgumentUtil.getRegionArgument((CommandContext<class_2168>)ctx), true)))))).then(ArgumentUtil.literal(CommandConstants.DESELECT).executes(ctx -> MarkerCommands.selectRegion((CommandContext<class_2168>)ctx, ArgumentUtil.getRegionArgument((CommandContext<class_2168>)ctx), false)))).then(ArgumentUtil.literal(CommandConstants.CREATE).then(((RequiredArgumentBuilder)class_2170.method_9244((String)CommandConstants.NAME.toString(), (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> class_2172.method_9265(Collections.singletonList(DimensionCommands.getRandomExample()), (SuggestionsBuilder)builder)).executes(ctx -> MarkerCommands.createMarkedRegion((CommandContext<class_2168>)ctx, ArgumentUtil.getRegionNameArgument((CommandContext<class_2168>)ctx), null))).then(class_2170.method_9244((String)CommandConstants.PARENT.toString(), (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> ContainingOwnedRegionArgumentType.owningRegions().listSuggestionsWithMarker(ctx, builder)).executes(ctx -> MarkerCommands.createMarkedRegion((CommandContext<class_2168>)ctx, ArgumentUtil.getRegionNameArgument((CommandContext<class_2168>)ctx), ArgumentUtil.getContainingOwnedRegionArgumentWithMarker((CommandContext<class_2168>)ctx))))));
    }

    private static int selectRegion(CommandContext<class_2168> ctx, IMarkableRegion region, boolean select) {
        return 0;
    }

    public static IMarkableRegion fromMarkedBlocks(CommandContext<class_2168> ctx, class_1657 player, String regionName) throws CommandSyntaxException {
        class_1799 maybeStick = player.method_6047();
        if (StickUtil.isMarker(maybeStick)) {
            class_2487 stickNBT = StickUtil.getStickNBT(maybeStick);
            if (stickNBT != null) {
                MarkerStick marker = new MarkerStick(stickNBT);
                if (!marker.isValidArea()) {
                    MessageSender.sendCmdFeedback((class_2168)ctx.getSource(), class_2561.method_48321((String)"cli.msg.dim.info.region.create.stick.area.invalid", (String)"Marked area is not valid").method_27692(class_124.field_1061));
                    return null;
                }
                return LocalRegions.regionFrom(player, marker, regionName);
            }
            MessageSender.sendCmdFeedback((class_2168)ctx.getSource(), class_2561.method_48321((String)"cli.msg.dim.info.region.create.stick.invalid", (String)"Invalid RegionMarker data, sorry. Get a new one and try again."));
            return null;
        }
        MessageSender.sendCmdFeedback((class_2168)ctx.getSource(), class_2561.method_48321((String)"cli.msg.dim.info.region.create.stick.missing", (String)"Put a valid(*) RegionMarker in your main hand to create a region!").method_27692(class_124.field_1061));
        return null;
    }

    private static int createMarkedRegion(CommandContext<class_2168> ctx, String regionName, IProtectedRegion parentRegion) {
        try {
            DimensionRegionCache dimCache = RegionDataManager.get().cacheFor((class_5321<class_1937>)((class_2168)ctx.getSource()).method_9225().method_27983());
            int res = RegionDataManager.get().isValidRegionName(dimCache.getDimensionalRegion().getDim(), regionName);
            if (res == -1) {
                MessageSender.sendCmdFeedback((class_2168)ctx.getSource(), class_2561.method_48322((String)"cli.msg.dim.info.region.create.name.invalid", (String)"Invalid region name supplied: '%s'", (Object[])new Object[]{regionName}));
                return res;
            }
            if (res == 1) {
                MessageSender.sendCmdFeedback((class_2168)ctx.getSource(), class_2561.method_48322((String)"cli.msg.dim.info.region.create.name.exists", (String)"Dimension %s already contains region with name %s", (Object[])new Object[]{ChatLinkBuilder.buildRegionInfoLink(dimCache.getDimensionalRegion()), ChatLinkBuilder.buildRegionInfoLink(dimCache.getRegion(regionName))}));
                return res;
            }
            class_3222 player = ((class_2168)ctx.getSource()).method_9207();
            IMarkableRegion newRegion = MarkerCommands.fromMarkedBlocks(ctx, (class_1657)player, regionName);
            if (newRegion == null) {
                MessageSender.sendCmdFeedback((class_2168)ctx.getSource(), class_2561.method_48321((String)"cli.msg.dim.info.region.create.stick.area.invalid", (String)"Marked area is not valid").method_27692(class_124.field_1061));
                return -1;
            }
            IProtectedRegion parent = parentRegion == null ? dimCache.getDimensionalRegion() : parentRegion;
            return MarkerCommands.createRegion(ctx, (class_1657)player, dimCache, newRegion, parent);
        }
        catch (CommandSyntaxException e) {
            Constants.LOGGER.error((Object)e);
            MessageSender.sendCmdFeedback((class_2168)ctx.getSource(), class_2561.method_48321((String)"cli.msg.dim.info.region.create.stick.no-player", (String)"This command can only be executed as a player!").method_27692(class_124.field_1061));
            return -1;
        }
    }

    private static int createRegion(CommandContext<class_2168> ctx, class_1657 player, DimensionRegionCache dimCache, IMarkableRegion region, IProtectedRegion parentRegion) {
        if (Services.EVENT.post(new RegionEvent.Create(region, player))) {
            return 1;
        }
        boolean hasConfigPermission = Permissions.get().hasConfigPermission(player);
        boolean hasRegionPermission = Permissions.get().hasGroupPermission(parentRegion, player, "owners");
        if (hasConfigPermission || hasRegionPermission) {
            RegionDataManager.addFlags(Services.REGION_CONFIG.getDefaultFlags(), region);
            dimCache.addRegion(parentRegion, region);
            LocalRegions.ensureHigherRegionPriorityFor(region, Services.REGION_CONFIG.getDefaultPriority());
            RegionDataManager.save();
            MessageSender.sendCmdFeedback((class_2168)ctx.getSource(), class_2561.method_48322((String)"cli.msg.dim.info.region.create.success", (String)"Successfully created region %s (parent: %s)", (Object[])new Object[]{ChatLinkBuilder.buildRegionInfoLink(region), ChatLinkBuilder.buildRegionInfoLink(parentRegion)}));
            return 0;
        }
        MessageSender.sendCmdFeedback((class_2168)ctx.getSource(), class_2561.method_48322((String)"cli.msg.dim.info.region.create.local.deny", (String)"You don't have the permission to create a region in the region %s!", (Object[])new Object[]{ChatLinkBuilder.buildRegionInfoLink(parentRegion)}));
        return 1;
    }

    private static int resetStick(CommandContext<class_2168> ctx) {
        try {
            class_3222 player = ((class_2168)ctx.getSource()).method_9207();
            class_1799 mainHandItem = player.method_6047();
            if (!mainHandItem.equals(class_1799.field_8037) && StickUtil.isMarker(mainHandItem)) {
                StickUtil.resetMarkerNbt(mainHandItem, (class_5321<class_1937>)player.method_37908().method_27983());
                MessageSender.sendCmdFeedback((class_2168)ctx.getSource(), class_2561.method_48321((String)"cli.msg.dim.info.region.create.stick.reset", (String)"RegionMarker successfully reset!"));
                return 0;
            }
            MessageSender.sendCmdFeedback((class_2168)ctx.getSource(), class_2561.method_48321((String)"cli.msg.dim.info.region.create.stick.missing", (String)"Put a valid(*) RegionMarker in your main hand to create a region!").method_27692(class_124.field_1061));
            return 1;
        }
        catch (CommandSyntaxException e) {
            MessageSender.sendCmdFeedback((class_2168)ctx.getSource(), class_2561.method_48321((String)"cli.msg.dim.info.region.create.stick.no-player", (String)"This command can only be executed as a player!").method_27692(class_124.field_1061));
            return 1;
        }
    }

    private static int giveMarkerStick(CommandContext<class_2168> ctx) {
        try {
            class_3222 targetPlayer = ((class_2168)ctx.getSource()).method_9207();
            class_1799 marker = class_1802.field_8600.method_7854();
            StickUtil.initMarkerNbt(marker, (class_5321<class_1937>)targetPlayer.method_37908().method_27983());
            targetPlayer.method_7270(marker);
            MessageSender.sendCmdFeedback((class_2168)ctx.getSource(), class_2561.method_48321((String)"cli.msg.dim.info.region.create.stick.success", (String)"RegionMarker added to your inventory!"));
        }
        catch (CommandSyntaxException e) {
            MessageSender.sendCmdFeedback((class_2168)ctx.getSource(), class_2561.method_48321((String)"cli.msg.dim.info.region.create.stick.no-player", (String)"This command can only be executed as a player!").method_27692(class_124.field_1061));
            return 1;
        }
        return 0;
    }
}

